/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker.LegendaryHeroMaker;

import LegendaryCardMaker.Icon;
import LegendaryCardMaker.LegendaryCardMakerFrame;
import LegendaryCardMaker.LegendaryHeroMaker.Hero;
import LegendaryCardMaker.LegendaryHeroMaker.HeroCard;
import LegendaryCardMaker.LegendaryHeroMaker.HeroCardSelectorToolbar;
import LegendaryCardMaker.LegendaryHeroMaker.HeroMakerFrame;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class HeroCardSelector
extends JDialog {
    Hero h;
    public JList cardList;
    public DefaultListModel cardListModel;
    JScrollPane cardScroll = new JScrollPane();
    HeroCardSelectorToolbar tb;
    public LegendaryCardMakerFrame lcmf;

    public HeroCardSelector(Hero h, LegendaryCardMakerFrame lcmf) {
        this.lcmf = lcmf;
        this.tb = new HeroCardSelectorToolbar(this);
        this.setJMenuBar(this.tb);
        this.setTitle("Card Selector: " + h.name);
        this.h = h;
        this.setDefaultCloseOperation(2);
        this.cardListModel = new DefaultListModel();
        for (HeroCard hc : h.cards) {
            this.cardListModel.addElement(hc);
        }
        this.cardList = new JList(this.cardListModel);
        this.cardList.setCellRenderer(new CardListRenderer());
        this.cardList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                int index;
                JList list = (JList)evt.getSource();
                if (evt.getClickCount() == 2 && (index = list.locationToIndex(evt.getPoint())) >= 0) {
                    HeroMakerFrame heroMakerFrame = new HeroMakerFrame((HeroCard)list.getSelectedValue());
                }
            }
        });
        this.cardScroll.setViewportView(this.cardList);
        this.add(this.cardScroll);
        this.setModal(true);
        this.setSize(400, 300);
        this.setVisible(true);
    }

    public BufferedImage getCardIcon(Icon icon, int maxWidth, int maxHeight) {
        if (icon == null || icon.getImagePath() == null) {
            int type = 2;
            BufferedImage image = new BufferedImage(maxWidth, maxHeight, type);
            return image;
        }
        ImageIcon ii = new ImageIcon(icon.getImagePath());
        double r = 1.0;
        double rX = (double)maxWidth / (double)ii.getIconWidth();
        double rY = (double)maxHeight / (double)ii.getIconHeight();
        r = rY < rX ? rY : rX;
        return this.resizeImage(ii, r);
    }

    public BufferedImage resizeImage(ImageIcon imageIcon, double scale) {
        int w = (int)((double)imageIcon.getIconWidth() * scale);
        int h = (int)((double)imageIcon.getIconHeight() * scale);
        int type = 2;
        BufferedImage image = new BufferedImage(w, h, type);
        Graphics g = image.getGraphics();
        g.drawImage(imageIcon.getImage(), 0, 0, w, h, 0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight(), null);
        g.dispose();
        return image;
    }

    public class CardListRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            HeroCard card = (HeroCard)value;
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (card.imageSummary != null) {
                label.setIcon(card.imageSummary);
            } else {
                card.imageSummary = new ImageIcon(this.getImageSummary(card));
                label.setIcon(card.imageSummary);
            }
            label.setHorizontalTextPosition(4);
            String s = String.valueOf(card.name) + " (" + card.rarity.toString() + ")";
            if (card.changed) {
                s = String.valueOf(s) + " *";
            }
            label.setText(s);
            return label;
        }

        private BufferedImage getImageSummary(HeroCard h) {
            int maxWidth = 24;
            int maxHeight = 24;
            BufferedImage bi = new BufferedImage(maxWidth * 3, maxHeight, 2);
            Graphics g2 = bi.getGraphics();
            int offset = 0;
            BufferedImage icon = HeroCardSelector.this.getCardIcon(h.cardTeam, maxWidth, maxHeight);
            g2.drawImage(icon, offset + (maxWidth / 2 - icon.getWidth() / 2), maxHeight / 2 - icon.getHeight() / 2, null);
            icon = HeroCardSelector.this.getCardIcon(h.cardPower, maxWidth, maxHeight);
            g2.drawImage(icon, (offset += maxWidth) + (maxWidth / 2 - icon.getWidth() / 2), maxHeight / 2 - icon.getHeight() / 2, null);
            g2.dispose();
            return bi;
        }
    }
}

